#ifndef ClientThread_Cpp
#define ClientThread_Cpp
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "SockServer.H"

#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/HandShake.H"
#include "../Source/Command.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HANDLE ghEvent_ClientThread = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SocketServer::OnBegin_ClientThread(int iClient)
{
	memset(&CTI, 0, sizeof(CTI));
    CTI.Client = iClient;

	CCI[iClient].bIsAuthenticated = false;
	CCI[iClient].bIsEncryptionInit = false;
	CCI[iClient].bWPIndexConnected = false;
	CCI[iClient].bWPCustomerConnected = false;
	CCI[iClient].iAuthStep = 0;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SocketServer::OnEnd_ClientThread(int iClient)
{
	if(CCI[iClient].bWPIndexConnected)
	{
		CCI[iClient].IndexDB.DBDisconnect();
	}

	if(CCI[iClient].bWPCustomerConnected)
	{
		CCI[iClient].CustDB.DBDisconnect();
	}

	if(CCI[iClient].bIsEncryptionInit)
	{
		WriteLog(icClientID[iClient], "Uninitializing Cryptography Set...");
		CCI[iClient].MyCrypt.UninitializeCryptographySet();
		CCI[iClient].bIsEncryptionInit = false;
	}
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SocketServer::Start_ClientThread(int iClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> SocketServer::Start_ClientThread.\n");
    #endif

    ghEvent_ClientThread = CreateEvent(NULL, FALSE, FALSE, "Client_Thread_Function");

	OnBegin_ClientThread(iClient);

	if((hcClient_Thread_Handle[iClient] = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)Client_Thread_Function, (LPVOID) this, 0, (LPDWORD) &dwcClient_Thread_ID[iClient])) == NULL)
    {
		WriteLog(icClientID[iClient], "SocketServer::Start_ClientThread : CreateThread failed.");
        CloseHandle(ghEvent_ClientThread);
        return false;
    }

    if(WaitForSingleObject(ghEvent_ClientThread, 5000) == WAIT_TIMEOUT)
    {
        CloseHandle(ghEvent_ClientThread);
        return false;
    }

    CloseHandle(ghEvent_ClientThread);
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SocketServer::WaitOnClientThreadToExit(int iClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> SocketServer::WaitOnClientThreadToExit.\n");
    #endif

    DWORD dwExitCode = 0;

    int iWaitCount = 0;

    while(GetExitCodeThread(hcClient_Thread_Handle[iClient], &dwExitCode))
    {
        if(dwExitCode != STILL_ACTIVE || iWaitCount == 500)
        {
            if(iWaitCount == 500)
            {
                WriteLog(icClientID[iClient], "Possible thread dead-lock. Client's thread will be terminated.");
                TerminateThread(hcClient_Thread_Handle[iClient], 1);
            }

            CloseHandle(hcClient_Thread_Handle[iClient]);
            dwcClient_Thread_ID[iClient] = 0;

			OnEnd_ClientThread(iClient);

			return true;
        }

        iWaitCount++;
        Sleep(1);
    }

    CloseHandle(hcClient_Thread_Handle[iClient]);
	dwcClient_Thread_ID[iClient] = 0;

	OnEnd_ClientThread(iClient);

	WriteLog(icClientID[iClient], "SocketServer::WaitOnClientThreadToExit : GetExitCodeThread failed.");
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI Client_Thread_Function(LPVOID pvThread)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> Client_Thread_Function.\n");
    #endif

    //---------------------(Initialize Thread [Begin])----------
   	SocketServer *pSockSrvr = ((SocketServer *)pvThread);

	int iClient = ((SocketServer *)pvThread)->CTI.Client;

	SetEvent(ghEvent_ClientThread);
    //---------------------(Initialize Thread [END])----------

    char sRecvBuf[MAXRECVSIZE + 1];
    int iRecvBufSz = 0;

	pSockSrvr->SetNextSendData(iClient, "::RequestAuthString");

    while(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
    {
        if(pSockSrvr->GetClientData(iClient, sRecvBuf, &iRecvBufSz))
        {
			//sRecvBuf[iRecvBufSz] = '\0';
			printf("GotSize[%d] : %d\n", iClient, iRecvBufSz);
			//printf("GotData[%d]:%s\n", iClient, sRecvBuf);

			if(CCI[iClient].bIsAuthenticated == false)
			{
				int iAuthResult = PerformHandShake(pSockSrvr, iClient, sRecvBuf, iRecvBufSz);
				if(iAuthResult == AUTH_FAILED || iAuthResult == AUTH_ERROR)
				{
					pSockSrvr->bcDisconnect[iClient] = true;
					return 0;
				}
				else if(iAuthResult == AUTH_SUCCESS){
					if(CCI[iClient].CustDB.DBConnect(gsSQLCustDriver, gsSQLCustServer, gsSQLCustUserID, gsSQLCustPassword, CCI[iClient].sCompanyDatabase))
					{
						WriteLog(pSockSrvr->icClientID[iClient], "Successfully connected to the Customer database.");
						CCI[iClient].bWPCustomerConnected = true;
						CCI[iClient].bIsAuthenticated = true;
					}
					else{
						WriteLog(pSockSrvr->icClientID[iClient], "Failed to connect to the Customer database.");
						pSockSrvr->bcDisconnect[iClient] = true;
						return 0;						
					}
				}
				else if(iAuthResult == AUTH_OK){
					//The authentication process is still in process, all is well.
				}
			}
			else{
				int iCmdResult = ProcessCommand(pSockSrvr, iClient, sRecvBuf, iRecvBufSz);
				if(iCmdResult == CMD_ERROR)
				{
					WriteLog(pSockSrvr->icClientID[iClient], "Process command returned with an error.");
					pSockSrvr->bcDisconnect[iClient] = true;
					return 0;
				}
				else if(iCmdResult == CMD_DONE) {
					pSockSrvr->bcDisconnect[iClient] = true;
					return 0;
				}
				else if(iCmdResult == CMD_OK) {
					//All is well.
				}
			}
		}
        else Sleep(CLIENTTHREAD_MS_WAIT);
    }

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

